/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.launch.remote;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.launch.remote.Messages;
import com.aptana.php.debug.core.util.NameValuePair;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.browser.IWebBrowser;

public class RemoteDebugRedirector {
    private static final int REDIRECTION_SERVER_DELAY = 3000;
    private static final String LINE_TERMINATOR = FileUtil.NEW_LINE;
    private ServerSocket server;
    private String response;

    public IStatus redirect(IWebBrowser browser, URL target, List<String> postData) {
        if (browser == null) {
            throw new IllegalArgumentException("The given target browser was null");
        }
        try {
            this.startServer();
            this.buildResponse(target, postData);
            Thread.sleep(1000L);
            browser.openURL(new URL("http", "127.0.0.1", this.server.getLocalPort(), ""));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"Error while redirecting the PHP Debug session", (Throwable)e, (String)"com.aptana.php.debug/debug");
            this.stopServer();
            return new Status(4, "com.aptana.php.debug", Messages.RemoteDebugRedirector_redirectingError);
        }
        return Status.OK_STATUS;
    }

    private void buildResponse(URL target, List<String> postData) throws UnsupportedEncodingException {
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append("<HTML><BODY><FORM id=\"postForm\" action=\"");
        responseBuilder.append(target);
        responseBuilder.append("\" method=\"post\" target=\"_self\">");
        if (postData != null) {
            for (String pair : postData) {
                NameValuePair nameValuePair = NameValuePair.fromPairString(pair);
                if (nameValuePair == null) continue;
                responseBuilder.append("<input type=\"hidden\" name=\"");
                responseBuilder.append(nameValuePair.name);
                responseBuilder.append("\" value=\"");
                responseBuilder.append(URLEncoder.encode(nameValuePair.value, "UTF-8"));
                responseBuilder.append("\">");
            }
        }
        responseBuilder.append("</FORM><SCRIPT type=\"text/javascript\"> function submitPost() { var frm = document.getElementById(\"postForm\"); frm.submit(); } window.onload = submitPost; </SCRIPT>");
        this.response = responseBuilder.toString();
    }

    protected void startServer() throws IOException {
        this.server = new ServerSocket(0);
        Job job = new Job("PHP Debug Server Redirector"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        Socket socket = null;
                        FilterOutputStream writer = null;
                        try {
                            socket = RemoteDebugRedirector.this.server.accept();
                            writer = new DataOutputStream(socket.getOutputStream());
                            ((DataOutputStream)writer).writeBytes("HTTP/1.1 200 OK" + LINE_TERMINATOR);
                            ((DataOutputStream)writer).writeBytes("Server: PHP Debug Proxy Server");
                            ((DataOutputStream)writer).writeBytes("Content-Type: text/html" + LINE_TERMINATOR);
                            ((DataOutputStream)writer).writeBytes("Content-Length: " + RemoteDebugRedirector.this.response.length() + LINE_TERMINATOR);
                            ((DataOutputStream)writer).writeBytes("Connection: close" + LINE_TERMINATOR);
                            ((DataOutputStream)writer).writeBytes(LINE_TERMINATOR);
                            ((DataOutputStream)writer).writeBytes(RemoteDebugRedirector.this.response);
                            ((DataOutputStream)writer).flush();
                        }
                        finally {
                            if (writer != null) {
                                writer.close();
                            }
                            if (socket != null) {
                                socket.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"PHP Debug Proxy error", (Throwable)e);
                        RemoteDebugRedirector.this.stopServer();
                    }
                }
                finally {
                    RemoteDebugRedirector.this.stopServer();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(3000L);
    }

    protected void stopServer() {
        Job stoppingServerJob = new Job("PHP Debug Server Redirector Shutdown"){

            protected IStatus run(IProgressMonitor monitor) {
                if (RemoteDebugRedirector.this.server != null) {
                    try {
                        RemoteDebugRedirector.this.server.close();
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"Error closing a server redirector", (Throwable)e);
                    }
                    RemoteDebugRedirector.this.server = null;
                }
                return Status.OK_STATUS;
            }
        };
        stoppingServerJob.setSystem(true);
        stoppingServerJob.schedule(3000L);
    }
}

